@extends('layout.pageheader')
@section('title', 'CheckOut')
@section('content')
<div class="mad-content no-pd">
    <div class="container">
        <div class="mad-section">
            <div class="content-element-15">
                <p class="mad-text-small mad-text-color-3">Required fields are followed by <span class="req">*</span></p>
                <!--================ Horizontal Table ================-->
                <div class="mad-table-wrap shop-cart-form">
                    <table class="mad-table--responsive-md">
                        <thead>
                            <tr class="bg">
                                <th>Product</th>
                                <th>Price</th>
                                <th>Quantity</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <form id="product">
                                @foreach($results as $result)
                                <tr class="mad-product-item">
                                    <td data-cell-title="Product">
                                        <div class="mad-products mad-product-small">
                                            <div class="mad-col">
                                                <!-- Product -->
                                                <div class="mad-product">
                                                    <a href="#" class="mad-product-image">
                                                        <img src="images/72x72_img1.jpg" alt="">
                                                    </a>
                                                    <!-- product-info -->
                                                    <div class="mad-product-description">
                                                        <h5 class="mad-product-title"><a href="#">{{$result->product_name}}</a></h5>
                                                        <p></p>
                                                    </div>
                                                    <!--/ product-info -->
                                                </div>
                                                <!-- End of Product -->
                                            </div>
                                        </div>
                                    </td>
                                    <td data-cell-title="Price"><span class="mad-product-price">{{$result->total_price}}</span></td>
                                    <td data-cell-title="productatt">
                                        <p>
                                            {{$result->wings_name}},
                                            {{$result->sauces_name}},
                                            {{$result->crusts_name}},
                                            {{$result->dippings_name}},
                                            {{$result->cookings_name}},
                                            @foreach($result->insert_topping as $insert_topping)
                                            {{$insert_topping->toppings_left_name ? $insert_topping->toppings_left_name .',' : ''}}
                                            {{$insert_topping->toppings_center_name ? $insert_topping->toppings_center_name .',' : ''}}
                                            {{$insert_topping->toppings_right_name ? $insert_topping->toppings_right_name .',' : ''}}
                                            @endforeach
                                        </p>
                                    </td>
                                    <td class="shopping-cart-full" data-cell-title="Actions"><a href="{{url('checkout/delete')}}/{{$result->id}}">Remove</a>
                                    </td>
                                </tr>
                                <input type="hidden" value="{{$result->id}}" name="product_id[]">
                                <input type="hidden" value="{{$result->product_name}}" name="product_name[]">
                                <input type="hidden" value="{{$result->product_price}}" name="product_price[]">
                                <input type="hidden" value="{{$result->pqty}}" name="pqty[]">
                                <input type="hidden" value="{{$result->wings_name}}" name="wings_name[]">
                                <input type="hidden" value="{{$result->ws_price}}" name="ws_price[]">
                                <input type="hidden" value="{{$result->sauces_name}}" name="sauces_name[]">
                                <input type="hidden" value="{{$result->sauce_price}}" name="sauce_price[]">
                                <input type="hidden" value="{{$result->crusts_name}}" name="crusts_name[]">
                                <input type="hidden" value="{{$result->crust_price}}" name="crust_price[]">
                                <input type="hidden" value="{{$result->dippings_name}}" name="dippings_name[]">
                                <input type="hidden" value="{{$result->dipping_price}}" name="dipping_price[]">
                                <input type="hidden" value="{{$result->cookings_name}}" name="cookings_name[]">
                                <input type="hidden" value="{{$result->cooking_price}}" name="cooking_price[]">
                                @foreach($result->insert_topping as $insert_topping)
                                <input type="hidden" value="{{$insert_topping->toppings_left_name}}" name="toppings_left_name[]">
                                <input type="hidden" value="{{$insert_topping->toppings_left_id}}" name="toppings_left_id[]">
                                <input type="hidden" value="{{$insert_topping->toppingsqty}}" name="toppingsqty[]">
                                <input type="hidden" value="{{$insert_topping->toppings_center_name}}" name="toppings_center_name[]">
                                <input type="hidden" value="{{$insert_topping->toppings_center_id}}" name="toppings_center_id[]">
                                <input type="hidden" value="{{$insert_topping->toppingsqty}}" name="toppingsqty[]">
                                <input type="hidden" value="{{$insert_topping->toppings_right_name}}" name="toppings_right_name[]">
                                <input type="hidden" value="{{$insert_topping->toppings_right_id}}" name="toppings_right_id[]">
                                <input type="hidden" value="{{$insert_topping->toppingsqty}}" name="toppingsqty[]">
                                @endforeach
                                <input type="hidden" value="{{$result->user_id}}" name="user_id">
                                <input type="hidden" value="{{$results->sum('total_price')}}" name="total_price">

                                @endforeach
                            </form>
                        </tbody>
                    </table>
                </div>
                <!--================ End of Horizontal Table ================-->
            </div>
            <div class="content-element-15">
                <div class="row vr-size-5">
                    <div class="col-lg-6">
                        <h3>I Would Like My Order</h3>
                        <form class="mad-contact-form type-2 var2" id="userdetail">
                            @csrf
                            <div class="content-element-15">
                                <div class="form-control content-element-4">
                                    <p>Your email address will not be published.</p>
                                    <div style="display: block;" class="mad-toggled-fields">
                                        <input type="radio" name="delivered_type" id="radio-1" checked="checked" value="delivered">
                                        <label for="radio-1" class="mad-label-radio">Delivered</label>
                                        <input type="radio" name="delivered_type" id="radio-2" value="takeout">
                                        <label for="radio-2" class="mad-label-radio">Take Out</label>
                                    </div>
                                </div>

                                <!-- <div class="mad-col">
                                        <label>Address Type <span>*</span></label>
                                        <div class="mad-custom-select">
                                            <select data-default-text=" ">
                                                <option>Option 1</option>
                                                <option>Option 2</option>
                                                <option>Option 3</option>
                                            </select>
                                        </div>
                                    </div> -->
                                <div class="mad-col">
                                    <label>Street <span>*</span></label>
                                    <input type="text" placeholder="Street" name="street" id="location">
                                </div>
                                <div class="mad-col">
                                    <label>Apt/Ste/Rm <span>*</span></label>
                                    <input type="text" placeholder="Apt/Ste/Rm" name="appertment">
                                </div>
                                <div class="mad-col">
                                    <label>Gate Code</label>
                                    <input type="text" placeholder="Gate Code" name="zipcode">
                                </div>
                                <div class="mad-col">
                                    <label>Notes</label>
                                    <input type="text" placeholder="Notes" name="note">
                                </div>
                                <div class="mad-col">
                                <div class="input-wrapper">
                                    <input type="checkbox" id="checkbox" name="checkbox">
                                    <label for="checkbox">Same As Above</label>
                                </div>
                            </div>

                        </form>
                    </div>
                    <div class="content-element-15" style="padding-top: 30px;">
                        <h3>Order Totals</h3>
                        <div class="content-element-3">
                            <div class="mad-table-wrap">
                                <table class="mad-table mad-table--vertical">
                                    <tbody>
                                        <tr>
                                            <th>Subtotal</th>
                                            <td><span class="mad-product-price">{{ $results->sum('total_price') }}</span></td>
                                        </tr>
                                        <tr>
                                            <th>Delivery</th>
                                            <td><span class="mad-product-price">0</span></td>
                                        </tr>
                                        <tr>
                                            <th>Tax</th>
                                            <td>

                                                @if($results->sum('total_price') == 0)
                                                <span class="mad-product-price">0</span>
                                                @else
                                                <span style="font-weight: bold;font-size: 1.125rem;color: #232223;font-family: 'Josefin Sans', sans-serif;">13%</span>

                                                @endif

                                            </td>
                                        </tr>
                                    </tbody>
                                    <tfoot>
                                        <tr class="bg">
                                            <th>Total </th>
                                            <td><span class="mad-product-price">{{ $results->sum('total_price') * 1.13 }}</span></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                        <a href="#"><img src="images/paycards.jpg" alt=""></a>
                    </div>

                </div>
                <div class="col-lg-6">
                    <div class="content-element-15">
                        <h3>Billing Details</h3>
                        <form class="mad-contact-form type-2 var2" id="userbasic">
                            @csrf
                            <div class="mad-col">
                                <label>Email Address <span>*</span></label>
                                <input type="email" placeholder="Email Address" name="email">
                            </div>
                            <div class="mad-col">
                                <label>Phone Number <span>*</span></label>
                                <input type="tel" placeholder="Phone Number" name="phone">
                            </div>
                            <div class="mad-col">
                                <label>First Name <span>*</span></label>
                                <input type="text" placeholder="First Name" name="fname">
                            </div>
                            <div class="mad-col">
                                <label>Last Name</label>
                                <input type="text" placeholder="Last Name" name="lname">
                            </div>
                            
                        </form>
                    </div>
                    <!-- <div class="content-element-15">
                                <h3>Create an Account (optional)</h3>
                                <form class="mad-contact-form type-2 var2">
                                    <div class="mad-col">
                                        <label>Username</label>
                                        <input type="text" placeholder="Username">
                                        <span class="mad-text-small mad-text-color-3">The username you will use to log into your
                                            account.</span>
                                    </div>
                                    <div class="mad-col">
                                        <label>Password</label>
                                        <input type="text" placeholder="Password">
                                        <span class="mad-text-small mad-text-color-3">The password used to access your account.</span>
                                    </div>
                                    <div class="mad-col">
                                        <label>Password Again<br></label>
                                        <input type="text" placeholder="Confirm password">
                                        <span class="mad-text-small mad-text-color-3">Confirm your password.</span>
                                    </div>
                                </form>
                            </div> -->
                    <div class="content-element-15">
                        <form class="mad-contact-form type-2 content-element-6" id="payment">
                            @csrf
                            <div class="content-element-15">
                                <h3>Select Payment Method</h3>
                                <div class="form-control payment-option">
                                    <div style="display: block;" class="mad-toggled-fields">
                                        <input type="radio" name="payment_types" id="radio-5" checked="checked" value="cod">
                                        <label for="radio-5" class="mad-label-radio">
                                            Cash on delivery <br>
                                            <span>Pay with cash upon delivery.</span>
                                        </label>
                                        <!-- <input type="radio" name="radio-5" id="radio-6">
                                            <label for="radio-6" class="mad-label-radio">
                                                <div class="content-element">
                                                    Pay via PayPal
                                                </div>
                                                <span><b>Note: PayPal Sandbox account </b> is a preferable way of testing PayPal payments. If for some
                                                    reasons this method is not
                                                    suitable for you, test the payments via card using <a href="#" class="mad-link color-2">randomly
                                                        generated data</a>.</span>
                                            </label> -->
                                    </div>
                                    <!-- <div class="input-wrapper">
                                            <input type="checkbox" id="checkbox" name="checkbox">
                                            <label for="checkbox">Agree to Terms? <a href="#" class="mad-link color-2">Show Terms</a></label>
                                        </div> -->
                                </div>
                            </div>
                        </form>
                        <div class="mad-total-section">
                            <div class="mad-total-item">
                                <span>Total:</span>
                                <span class="mad-product-price">{{ $results->sum('total_price') * 1.13 }}</span>
                            </div>
                            <a href="javascript:void(0)" class="btn btn-big btn-style-3" onclick="purchase('')">Purchase</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>

@endsection
@section('script')
<script>
    function purchase() {

        jQuery.ajax({
            url: '/ordercomplete',
            data: jQuery('#userbasic').serialize() + '&' + jQuery('#userdetail').serialize() + '&' + jQuery('#payment').serialize() + '&' + jQuery('#product').serialize(),
            type: 'post',
            success: function(result) {
                jQuery('#thank_you_msg').html(result.msg);
                window.location.href = result.redirect;
            }
        })
    }
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?v=3.exp&libraries=places&key=AIzaSyCDwuBcNNbHNyTYq7cqrNtTVYMUndzStgc">
</script>

<!-- <script type="text/javascript">
    $(document).ready(function() {
        var autocomplete;
        var id = 'location';
        autocomplete = new google.maps.places.Autocomplete((document.getElementById(id)), {
            types: ['geocode'],
        })
    });
</script> -->

<script>
var searchInput = 'location';
 
$(document).ready(function () {
 var autocomplete;
 autocomplete = new google.maps.places.Autocomplete((document.getElementById(searchInput)), {
  types: ['geocode'],
  /*componentRestrictions: {
   country: "USA"
  }*/
 });
  
 google.maps.event.addListener(autocomplete, 'place_changed', function () {
  var near_place = autocomplete.getPlace();
 });
});
</script>
@endsection