<?php

namespace App\Http\Controllers;

use App\Models\wings;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class WingsController extends Controller
{
    public function index(Request $request, $id = '')
    {
        if ($id > 0) {
            $arr = wings::where(['id' => $id])->get();

            $result['wings_sauce'] = $arr['0']->wings_sauce;
            $result['ws_price'] = $arr['0']->ws_price;
            $result['status'] = $arr['0']->status;
            $result['id']=$arr['0']->id;
        } else {
            $result['wings_sauce'] = '';
            $result['ws_price'] = '';
            $result['status'] = '';
            $result['id']=0;
        }
        $wings = wings::all();
        return view('admin/wings-sauce', compact('wings'),$result);
    }

    public function create(Request $request)
    {
        $validatedData = $request->validate([
            "wings_sauce" => 'required|unique:wings,wings_sauce,'.$request->input('id'),

        ]);
        if($request->input('id')>0){
            $wings=wings::find($request->input('id'));
            $msg="Wings Sauce updated";
        }else{
            $wings = new wings;
            $msg="Wings Sauce inserted";
        }
        $wings->wings_sauce = $request->input('wings_sauce');
        $wings->ws_price = $request->input('ws_price');
        $wings->status=1;
        $wings->save();
        Session::flash('message', $msg);
        return redirect('admin/wings');
    }


    public function store(Request $request)
    {
    }

    public function show(wings $wings)
    {
    }

    public function edit(wings $wings)
    {
    }

    public function status(Request $request,$status,$id){
        $model=wings::find($id);
        $model->status=$status;
        $model->save();
        Session::flash('message','Wings Sauce status updated');
        return redirect('admin/wings');
    }

    public function delete(Request $request, $id)
    {
        $model = wings::find($id);
        $model->delete();
        Session::flash('message', 'Wings Sauce deleted');
        return redirect('admin/wings');
    }
}
