<?php

namespace App\Http\Controllers;

use App\Models\cooking;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class CookingController extends Controller
{
    public function index(Request $request, $id = '')
    {
        if ($id > 0) {
            $arr = cooking::where(['id' => $id])->get();

            $result['cooking'] = $arr['0']->cooking;
            $result['cooking_price'] = $arr['0']->cooking_price;
            $result['status'] = $arr['0']->status;
            $result['id']=$arr['0']->id;
        } else {
            $result['cooking'] = '';
            $result['cooking_price'] = '';
            $result['status'] = '';
            $result['id']=0;
        }
        $cookings = cooking::all();
        return view('admin/cooking', compact('cookings'),$result);
    }

    public function create(Request $request)
    {
        $validatedData = $request->validate([
            "cooking" => 'required|unique:cookings,cooking,'.$request->input('id'),

        ]);
        if($request->input('id')>0){
            $cookings=cooking::find($request->input('id'));
            $msg="Cooking updated";
        }else{
            $cookings = new cooking;
            $msg="Cooking inserted";
        }
        $cookings->cooking = $request->input('cooking');
        $cookings->cooking_price = $request->input('cooking_price');
        $cookings->status=1;
        $cookings->save();
        Session::flash('message', $msg);
        return redirect('admin/cooking');
    }


    public function store(Request $request)
    {
    }

    public function show(cooking $cooking)
    {
    }

    public function edit(cooking $cooking)
    {
    }

    public function status(Request $request,$status,$id){
        $model=cooking::find($id);
        $model->status=$status;
        $model->save();
        Session::flash('message','Cooking status updated');
        return redirect('admin/cooking');
    }

    public function delete(Request $request, $id)
    {
        $model = cooking::find($id);
        $model->delete();
        Session::flash('message', 'Cooking deleted');
        return redirect('admin/cooking');
    }
}
