@extends('layout.pageheader')
@section('title', 'Product')
@section('style')
<style>
  .noteorder {
    box-shadow: none;
    border-radius: 2rem;
    border: 2px solid #e6e6e6;
  }

  .mad-panels {
    margin-top: 20px;
  }
</style>
@endsection
@section('content')
<div class="mad-content">
  <div class="container">
    <div class="content-element-13">
      <div class="mad-product mad-product-single">
        <div class="row justify-content-center">
          <div class="col-xl-6 col-lg-8 col-md-10">
            <div class="image-preview-container">
              <div class="image-preview">
                <a href="{{asset('storage/media/'.$product->image)}}" data-fancybox="group">
                  <img id="zoom-image" src="{{asset('storage/media/'.$product->image)}}" alt="">
                </a>
              </div>
            </div>
            <h2 class="mad-product-title">{{$product->name}}
            </h2>
            <p>{{$product->short_desc}}</p>
            <div class="mad-product-calc">
              <span class="mad-product-price" id="p_price">{{$product->product_price}}</span>
            </div>
            @if($product->category_id === 1 || $product->category_id === 2 || $product->category_id === 4 || $product->category_id === 6)
            <div class="form-control content-element-6">
             
              <div class="content-element-2">
                <p class="mad-text-color-2 content-element">Size:</p>
                <div class="mad-toggled-fields hr-type">
                  @foreach($sizes as $size)
                  <input type="radio" name="size" id="radio-size{{$size->id}}">
                  <label for="radio-size{{$size->id}}" class="mad-label-radio" id="size_{{$size->size}}" onclick="size('{{$size->price}}','{{$size->size}}')">{{$size->size}}
                    <p class="attrprice"> ${{$size->price}}</p>
                  </label>
                  @endforeach
                </div>
              </div>
             

              <div class="content-element-2">
                <p class="mad-text-color-2 content-element">Sauces:</p>
                <div class="mad-toggled-fields hr-type">
                  @foreach($sauces as $sauces)
                  <input type="radio" name="sauces" id="radio-sauces{{$sauces->id}}">
                  <label for="radio-sauces{{$sauces->id}}" class="mad-label-radio" onclick="sauces('{{$sauces->sauce_price}}','{{$sauces->sauce}}')">{{$sauces->sauce}}
                    <p class="attrprice"> ${{$sauces->sauce_price}}</p>
                  </label>
                  @endforeach
                </div>
              </div>

              <div class="content-element-2">
                <p class="mad-text-color-2 content-element">Crusts:</p>
                <div class="mad-toggled-fields hr-type">
                  @foreach($crusts as $crusts)
                  <input type="radio" name="crusts" id="radio-crusts{{$crusts->id}}">
                  <label for="radio-crusts{{$crusts->id}}" class="mad-label-radio" onclick="crusts('{{$crusts->crust_price}}','{{$crusts->crust}}')">{{$crusts->crust}}
                    <p class="attrprice">${{$crusts->crust_price}}</p>
                  </label>
                  @endforeach
                </div>
              </div>
              <!-- topping small -->
              <dl role="presentation" class="mad-panels mad-panels--toggles" id="smalltoping">
                <p class="mad-text-color-2 content-element">Toppings:</p>
                @if($product->category_id == 1)
                <p>(3 Free Items)</p>
                @endif
                <form id="toppings_data">
                  @foreach($toppings as $toppings)

                  <dt class="mad-panels-title">
                    <button id="panel-44-button" type="button" aria-expanded="false" aria-controls="panel-44" aria-disabled="false">{{$toppings->toppings}}</button>
                  </dt>
                  <dd id="panel-44" class="mad-panels-definition" style="display: none;">
                    <p class="pizzadata">
                      <a href="javascript:void(0)" onclick="showprice('{{$toppings->id}}','{{$toppings->toppings_price/2}}','{{$toppings->toppings}}','toppingsqty')" id="showprice_{{$toppings->id}}" class="pizzahalf_link topping_type"><img src="{{asset('assets_front/images/pizza-left.png')}}" alt=""> </a>
                      <a href="javascript:void(0)" onclick="showpricenter('{{$toppings->id}}','{{$toppings->toppings_price}}','{{$toppings->toppings}}')" id="showpricenter_{{$toppings->id}}" class="pizzacircule_link topping_type"><img src="{{asset('assets_front/images/pizza-center.png')}}" alt=""></a>
                      <a href="javascript:void(0)" onclick="showpriceright('{{$toppings->id}}','{{$toppings->toppings_price/2}}','{{$toppings->toppings}}')" id="showpriceright_{{$toppings->id}}" class="toppings_link topping_type"><img src="{{asset('assets_front/images/pizza-right.png')}}" alt=""></a>
                      <label class="price-pizzahalf{{$toppings->id}}" style="display: none;" id="qtyleft">${{$toppings->toppings_price/2}}</label>
                      <label class="price-pizzacircule{{$toppings->id}}" style="display: none;">${{$toppings->toppings_price}}</label>
                      <label class="price-pizzaright{{$toppings->id}}" style="display: none;">${{$toppings->toppings_price/2}}</label>
                      <br>
                      <input type="number" value="0" name="toppingsqty[]" id="toppingsqty{{$toppings->id}}" class="toppingsqty" onchange="topsqtych('{{$toppings->id}}','{{$toppings->toppings_price}}')">
                    </p>
                  </dd>
                  <input type="hidden" id="toppings_left_name_{{$toppings->id}}" name="toppings_left_name[]" />
                  <input type="hidden" id="toppings_left_id_{{$toppings->id}}" name="toppings_left_id[]" />
                  <input type="hidden" id="toppings_center_name_{{$toppings->id}}" name="toppings_center_name[]" />
                  <input type="hidden" id="toppings_center_id_{{$toppings->id}}" name="toppings_center_id[]" />
                  <input type="hidden" id="toppings_right_name_{{$toppings->id}}" name="toppings_right_name[]" />
                  <input type="hidden" id="toppings_right_id_{{$toppings->id}}" name="toppings_right_id[]" />
                  @endforeach
                </form>
              </dl>
              <!-- topping small close -->

              <!-- topping mediam -->
              <dl role="presentation" class="mad-panels mad-panels--toggles" id="mediamtoping" style="display: none;">
                <p class="mad-text-color-2 content-element">Toppings:</p>
                @if($product->category_id == 1)
                <p>(3 Free Items)</p>
                @endif
                <form id="toppings_data_mediam">
                  @foreach($mediamtoppings as $toppings)

                  <dt class="mad-panels-title">
                    <button id="panel-44-button" type="button" aria-expanded="false" aria-controls="panel-44" aria-disabled="false">{{$toppings->toppings}}</button>
                  </dt>
                  <dd id="panel-44" class="mad-panels-definition" style="display: none;">
                    <p class="pizzadata">
                      <a href="javascript:void(0)" onclick="showprice('{{$toppings->id}}','{{$toppings->toppings_price/2}}','{{$toppings->toppings}}','toppingsqty')" id="showprice_{{$toppings->id}}" class="pizzahalf_link topping_type"><img src="{{asset('assets_front/images/pizza-left.png')}}" alt=""> </a>
                      <a href="javascript:void(0)" onclick="showpricenter('{{$toppings->id}}','{{$toppings->toppings_price}}','{{$toppings->toppings}}')" id="showpricenter_{{$toppings->id}}" class="pizzacircule_link topping_type"><img src="{{asset('assets_front/images/pizza-center.png')}}" alt=""></a>
                      <a href="javascript:void(0)" onclick="showpriceright('{{$toppings->id}}','{{$toppings->toppings_price/2}}','{{$toppings->toppings}}')" id="showpriceright_{{$toppings->id}}" class="toppings_link topping_type"><img src="{{asset('assets_front/images/pizza-right.png')}}" alt=""></a>
                      <label class="price-pizzahalf{{$toppings->id}}" style="display: none;" id="qtyleft">${{$toppings->toppings_price/2}}</label>
                      <label class="price-pizzacircule{{$toppings->id}}" style="display: none;">${{$toppings->toppings_price}}</label>
                      <label class="price-pizzaright{{$toppings->id}}" style="display: none;">${{$toppings->toppings_price/2}}</label>
                      <br>
                      <input type="number" value="0" name="toppingsqty[]" id="toppingsqty{{$toppings->id}}" class="toppingsqty" onchange="topsqtych('{{$toppings->id}}','{{$toppings->toppings_price}}')">
                    </p>
                  </dd>
                  <input type="hidden" id="toppings_left_name_{{$toppings->id}}" name="toppings_left_name[]" />
                  <input type="hidden" id="toppings_left_id_{{$toppings->id}}" name="toppings_left_id[]" />
                  <input type="hidden" id="toppings_center_name_{{$toppings->id}}" name="toppings_center_name[]" />
                  <input type="hidden" id="toppings_center_id_{{$toppings->id}}" name="toppings_center_id[]" />
                  <input type="hidden" id="toppings_right_name_{{$toppings->id}}" name="toppings_right_name[]" />
                  <input type="hidden" id="toppings_right_id_{{$toppings->id}}" name="toppings_right_id[]" />
                  @endforeach
                </form>
              </dl>
              <!-- large mediam -->

              <!-- topping large -->
              <dl role="presentation" class="mad-panels mad-panels--toggles" id="largetoping" style="display: none;">
                <p class="mad-text-color-2 content-element">Toppings:</p>
                @if($product->category_id == 1)
                <p>(3 Free Items)</p>
                @endif
                <form id="toppings_data_large">
                  @foreach($largetoppings as $toppings)

                  <dt class="mad-panels-title">
                    <button id="panel-44-button" type="button" aria-expanded="false" aria-controls="panel-44" aria-disabled="false">{{$toppings->toppings}}</button>
                  </dt>
                  <dd id="panel-44" class="mad-panels-definition" style="display: none;">
                    <p class="pizzadata">
                      <a href="javascript:void(0)" onclick="showprice('{{$toppings->id}}','{{$toppings->toppings_price/2}}','{{$toppings->toppings}}','toppingsqty')" id="showprice_{{$toppings->id}}" class="pizzahalf_link topping_type"><img src="{{asset('assets_front/images/pizza-left.png')}}" alt=""> </a>
                      <a href="javascript:void(0)" onclick="showpricenter('{{$toppings->id}}','{{$toppings->toppings_price}}','{{$toppings->toppings}}')" id="showpricenter_{{$toppings->id}}" class="pizzacircule_link topping_type"><img src="{{asset('assets_front/images/pizza-center.png')}}" alt=""></a>
                      <a href="javascript:void(0)" onclick="showpriceright('{{$toppings->id}}','{{$toppings->toppings_price/2}}','{{$toppings->toppings}}')" id="showpriceright_{{$toppings->id}}" class="toppings_link topping_type"><img src="{{asset('assets_front/images/pizza-right.png')}}" alt=""></a>
                      <label class="price-pizzahalf{{$toppings->id}}" style="display: none;" id="qtyleft">${{$toppings->toppings_price/2}}</label>
                      <label class="price-pizzacircule{{$toppings->id}}" style="display: none;">${{$toppings->toppings_price}}</label>
                      <label class="price-pizzaright{{$toppings->id}}" style="display: none;">${{$toppings->toppings_price/2}}</label>
                      <br>
                      <input type="number" value="0" name="toppingsqty[]" id="toppingsqty{{$toppings->id}}" class="toppingsqty" onchange="topsqtych('{{$toppings->id}}','{{$toppings->toppings_price}}')">
                    </p>
                  </dd>
                  <input type="hidden" id="toppings_left_name_{{$toppings->id}}" name="toppings_left_name[]" />
                  <input type="hidden" id="toppings_left_id_{{$toppings->id}}" name="toppings_left_id[]" />
                  <input type="hidden" id="toppings_center_name_{{$toppings->id}}" name="toppings_center_name[]" />
                  <input type="hidden" id="toppings_center_id_{{$toppings->id}}" name="toppings_center_id[]" />
                  <input type="hidden" id="toppings_right_name_{{$toppings->id}}" name="toppings_right_name[]" />
                  <input type="hidden" id="toppings_right_id_{{$toppings->id}}" name="toppings_right_id[]" />
                  @endforeach
                </form>
              </dl>
              <!-- large close -->

              <!-- topping party -->
              <dl role="presentation" class="mad-panels mad-panels--toggles" id="partytoping" style="display: none;">
                <p class="mad-text-color-2 content-element">Toppings:</p>
                @if($product->category_id == 1)
                <p>(3 Free Items)</p>
                @endif
                <form id="toppings_data_party">
                  @foreach($partytoppings as $toppings)

                  <dt class="mad-panels-title">
                    <button id="panel-44-button" type="button" aria-expanded="false" aria-controls="panel-44" aria-disabled="false">{{$toppings->toppings}}</button>
                  </dt>
                  <dd id="panel-44" class="mad-panels-definition" style="display: none;">
                    <p class="pizzadata">
                      <a href="javascript:void(0)" onclick="showprice('{{$toppings->id}}','{{$toppings->toppings_price/2}}','{{$toppings->toppings}}','toppingsqty')" id="showprice_{{$toppings->id}}" class="pizzahalf_link topping_type"><img src="{{asset('assets_front/images/pizza-left.png')}}" alt=""> </a>
                      <a href="javascript:void(0)" onclick="showpricenter('{{$toppings->id}}','{{$toppings->toppings_price}}','{{$toppings->toppings}}')" id="showpricenter_{{$toppings->id}}" class="pizzacircule_link topping_type"><img src="{{asset('assets_front/images/pizza-center.png')}}" alt=""></a>
                      <a href="javascript:void(0)" onclick="showpriceright('{{$toppings->id}}','{{$toppings->toppings_price/2}}','{{$toppings->toppings}}')" id="showpriceright_{{$toppings->id}}" class="toppings_link topping_type"><img src="{{asset('assets_front/images/pizza-right.png')}}" alt=""></a>
                      <label class="price-pizzahalf{{$toppings->id}}" style="display: none;" id="qtyleft">${{$toppings->toppings_price/2}}</label>
                      <label class="price-pizzacircule{{$toppings->id}}" style="display: none;">${{$toppings->toppings_price}}</label>
                      <label class="price-pizzaright{{$toppings->id}}" style="display: none;">${{$toppings->toppings_price/2}}</label>
                      <br>
                      <input type="number" value="0" name="toppingsqty[]" id="toppingsqty{{$toppings->id}}" class="toppingsqty" onchange="topsqtych('{{$toppings->id}}','{{$toppings->toppings_price}}')">
                    </p>
                  </dd>
                  <input type="hidden" id="toppings_left_name_{{$toppings->id}}" name="toppings_left_name[]" />
                  <input type="hidden" id="toppings_left_id_{{$toppings->id}}" name="toppings_left_id[]" />
                  <input type="hidden" id="toppings_center_name_{{$toppings->id}}" name="toppings_center_name[]" />
                  <input type="hidden" id="toppings_center_id_{{$toppings->id}}" name="toppings_center_id[]" />
                  <input type="hidden" id="toppings_right_name_{{$toppings->id}}" name="toppings_right_name[]" />
                  <input type="hidden" id="toppings_right_id_{{$toppings->id}}" name="toppings_right_id[]" />
                  @endforeach
                </form>
              </dl>
              <!-- party close -->
              <!-- small premium toppings -->
              <dl role="presentation" class="mad-panels mad-panels--toggles" id="smallpretoping">
                <p class="mad-text-color-2 content-element">Premium Toppings:</p>
                @if($product->category_id == 1)
                <p>(3 Free Items)</p>
                @endif
                <form id="pretoppings_data_small">
                  @foreach($pretoppings as $preTopping)

                  <dt class="mad-panels-title">
                    <button id="panel-44-button" type="button" aria-expanded="false" aria-controls="panel-44" aria-disabled="false">{{$preTopping->toppings}}</button>
                  </dt>
                  <dd id="panel-44" class="mad-panels-definition" style="display: none;">
                    <p class="pizzadata">
                      <a href="javascript:void(0)" onclick="preshowprice('{{$preTopping->id}}','{{$preTopping->toppings_price/2}}','{{$preTopping->toppings}}','toppingsqty')" id="preshowprice_{{$preTopping->id}}" class="pizzahalf_link pretopping_type"><img src="{{asset('assets_front/images/pizza-left.png')}}" alt=""> </a>
                      <a href="javascript:void(0)" onclick="preshowpricenter('{{$preTopping->id}}','{{$preTopping->toppings_price}}','{{$preTopping->toppings}}')" id="preshowpricenter_{{$preTopping->id}}" class="pizzacircule_link pretopping_type"><img src="{{asset('assets_front/images/pizza-center.png')}}" alt=""></a>
                      <a href="javascript:void(0)" onclick="preshowpriceright('{{$preTopping->id}}','{{$preTopping->toppings_price/2}}','{{$preTopping->toppings}}')" id="preshowpriceright_{{$preTopping->id}}" class="toppings_link pretopping_type"><img src="{{asset('assets_front/images/pizza-right.png')}}" alt=""></a>
                      <label class="preprice-pizzahalf{{$preTopping->id}}" style="display: none;" id="qtyleft">${{$preTopping->toppings_price/2}}</label>
                      <label class="preprice-pizzacircule{{$preTopping->id}}" style="display: none;">${{$preTopping->toppings_price}}</label>
                      <label class="preprice-pizzaright{{$preTopping->id}}" style="display: none;">${{$preTopping->toppings_price/2}}</label>
                      <br>
                      <input type="number" value="0" name="pretoppingsqty[]" id="pretoppingsqty{{$preTopping->id}}" class="toppingsqty" onchange="pretopsqtych('{{$preTopping->id}}','{{$preTopping->toppings_price}}')">
                    </p>
                  </dd>
                  <input type="hidden" id="pretoppings_left_name_{{$preTopping->id}}" name="pretoppings_left_name[]" />
                  <input type="hidden" id="pretoppings_left_id_{{$preTopping->id}}" name="pretoppings_left_id[]" />
                  <input type="hidden" id="pretoppings_center_name_{{$preTopping->id}}" name="pretoppings_center_name[]" />
                  <input type="hidden" id="pretoppings_center_id_{{$preTopping->id}}" name="pretoppings_center_id[]" />
                  <input type="hidden" id="pretoppings_right_name_{{$preTopping->id}}" name="pretoppings_right_name[]" />
                  <input type="hidden" id="pretoppings_right_id_{{$preTopping->id}}" name="pretoppings_right_id[]" />
                  @endforeach
                </form>
              </dl>
              <!-- close small toppings -->

              <!-- mediam premiam topping -->
              <dl role="presentation" class="mad-panels mad-panels--toggles" id="mediampretoping" style="display: none;">
                <p class="mad-text-color-2 content-element">Premium Toppings:</p>
                @if($product->category_id == 1)
                <p>(3 Free Items)</p>
                @endif
                <form id="pretoppings_data_mediam">
                  @foreach($mediam_pretoppings as $preTopping)

                  <dt class="mad-panels-title">
                    <button id="panel-44-button" type="button" aria-expanded="false" aria-controls="panel-44" aria-disabled="false">{{$preTopping->toppings}}</button>
                  </dt>
                  <dd id="panel-44" class="mad-panels-definition" style="display: none;">
                    <p class="pizzadata">
                      <a href="javascript:void(0)" onclick="preshowprice('{{$preTopping->id}}','{{$preTopping->toppings_price/2}}','{{$preTopping->toppings}}','toppingsqty')" id="preshowprice_{{$preTopping->id}}" class="pizzahalf_link pretopping_type"><img src="{{asset('assets_front/images/pizza-left.png')}}" alt=""> </a>
                      <a href="javascript:void(0)" onclick="preshowpricenter('{{$preTopping->id}}','{{$preTopping->toppings_price}}','{{$preTopping->toppings}}')" id="preshowpricenter_{{$preTopping->id}}" class="pizzacircule_link pretopping_type"><img src="{{asset('assets_front/images/pizza-center.png')}}" alt=""></a>
                      <a href="javascript:void(0)" onclick="preshowpriceright('{{$preTopping->id}}','{{$preTopping->toppings_price/2}}','{{$preTopping->toppings}}')" id="preshowpriceright_{{$preTopping->id}}" class="toppings_link pretopping_type"><img src="{{asset('assets_front/images/pizza-right.png')}}" alt=""></a>
                      <label class="preprice-pizzahalf{{$preTopping->id}}" style="display: none;" id="qtyleft">${{$preTopping->toppings_price/2}}</label>
                      <label class="preprice-pizzacircule{{$preTopping->id}}" style="display: none;">${{$preTopping->toppings_price}}</label>
                      <label class="preprice-pizzaright{{$preTopping->id}}" style="display: none;">${{$preTopping->toppings_price/2}}</label>
                      <br>
                      <input type="number" value="0" name="pretoppingsqty[]" id="pretoppingsqty{{$preTopping->id}}" class="toppingsqty" onchange="pretopsqtych('{{$preTopping->id}}','{{$preTopping->toppings_price}}')">
                    </p>
                  </dd>
                  <input type="hidden" id="pretoppings_left_name_{{$preTopping->id}}" name="pretoppings_left_name[]" />
                  <input type="hidden" id="pretoppings_left_id_{{$preTopping->id}}" name="pretoppings_left_id[]" />
                  <input type="hidden" id="pretoppings_center_name_{{$preTopping->id}}" name="pretoppings_center_name[]" />
                  <input type="hidden" id="pretoppings_center_id_{{$preTopping->id}}" name="pretoppings_center_id[]" />
                  <input type="hidden" id="pretoppings_right_name_{{$preTopping->id}}" name="pretoppings_right_name[]" />
                  <input type="hidden" id="pretoppings_right_id_{{$preTopping->id}}" name="pretoppings_right_id[]" />
                  @endforeach
                </form>
              </dl>
              <!-- close mediam premiam topping -->

              <!-- large premiam topping -->
              <dl role="presentation" class="mad-panels mad-panels--toggles" id="largepretoping" style="display: none;">
                <p class="mad-text-color-2 content-element">Premium Toppings:</p>
                @if($product->category_id == 1)
                <p>(3 Free Items)</p>
                @endif
                <form id="pretoppings_data_large">
                  @foreach($large_pretoppings as $preTopping)

                  <dt class="mad-panels-title">
                    <button id="panel-44-button" type="button" aria-expanded="false" aria-controls="panel-44" aria-disabled="false">{{$preTopping->toppings}}</button>
                  </dt>
                  <dd id="panel-44" class="mad-panels-definition" style="display: none;">
                    <p class="pizzadata">
                      <a href="javascript:void(0)" onclick="preshowprice('{{$preTopping->id}}','{{$preTopping->toppings_price/2}}','{{$preTopping->toppings}}','toppingsqty')" id="preshowprice_{{$preTopping->id}}" class="pizzahalf_link pretopping_type"><img src="{{asset('assets_front/images/pizza-left.png')}}" alt=""> </a>
                      <a href="javascript:void(0)" onclick="preshowpricenter('{{$preTopping->id}}','{{$preTopping->toppings_price}}','{{$preTopping->toppings}}')" id="preshowpricenter_{{$preTopping->id}}" class="pizzacircule_link pretopping_type"><img src="{{asset('assets_front/images/pizza-center.png')}}" alt=""></a>
                      <a href="javascript:void(0)" onclick="preshowpriceright('{{$preTopping->id}}','{{$preTopping->toppings_price/2}}','{{$preTopping->toppings}}')" id="preshowpriceright_{{$preTopping->id}}" class="toppings_link pretopping_type"><img src="{{asset('assets_front/images/pizza-right.png')}}" alt=""></a>
                      <label class="preprice-pizzahalf{{$preTopping->id}}" style="display: none;" id="qtyleft">${{$preTopping->toppings_price/2}}</label>
                      <label class="preprice-pizzacircule{{$preTopping->id}}" style="display: none;">${{$preTopping->toppings_price}}</label>
                      <label class="preprice-pizzaright{{$preTopping->id}}" style="display: none;">${{$preTopping->toppings_price/2}}</label>
                      <br>
                      <input type="number" value="0" name="pretoppingsqty[]" id="pretoppingsqty{{$preTopping->id}}" class="toppingsqty" onchange="pretopsqtych('{{$preTopping->id}}','{{$preTopping->toppings_price}}')">
                    </p>
                  </dd>
                  <input type="hidden" id="pretoppings_left_name_{{$preTopping->id}}" name="pretoppings_left_name[]" />
                  <input type="hidden" id="pretoppings_left_id_{{$preTopping->id}}" name="pretoppings_left_id[]" />
                  <input type="hidden" id="pretoppings_center_name_{{$preTopping->id}}" name="pretoppings_center_name[]" />
                  <input type="hidden" id="pretoppings_center_id_{{$preTopping->id}}" name="pretoppings_center_id[]" />
                  <input type="hidden" id="pretoppings_right_name_{{$preTopping->id}}" name="pretoppings_right_name[]" />
                  <input type="hidden" id="pretoppings_right_id_{{$preTopping->id}}" name="pretoppings_right_id[]" />
                  @endforeach
                </form>
              </dl>
              <!-- close large premiam topping -->

              <!-- party premiam topping -->
              <dl role="presentation" class="mad-panels mad-panels--toggles" id="partypretoping" style="display: none;">
                <p class="mad-text-color-2 content-element">Premium Toppings:</p>
                @if($product->category_id == 1)
                <p>(3 Free Items)</p>
                @endif
                <form id="pretoppings_data_party">
                  @foreach($party_pretoppings as $preTopping)

                  <dt class="mad-panels-title">
                    <button id="panel-44-button" type="button" aria-expanded="false" aria-controls="panel-44" aria-disabled="false">{{$preTopping->toppings}}</button>
                  </dt>
                  <dd id="panel-44" class="mad-panels-definition" style="display: none;">
                    <p class="pizzadata">
                      <a href="javascript:void(0)" onclick="preshowprice('{{$preTopping->id}}','{{$preTopping->toppings_price/2}}','{{$preTopping->toppings}}','toppingsqty')" id="preshowprice_{{$preTopping->id}}" class="pizzahalf_link pretopping_type"><img src="{{asset('assets_front/images/pizza-left.png')}}" alt=""> </a>
                      <a href="javascript:void(0)" onclick="preshowpricenter('{{$preTopping->id}}','{{$preTopping->toppings_price}}','{{$preTopping->toppings}}')" id="preshowpricenter_{{$preTopping->id}}" class="pizzacircule_link pretopping_type"><img src="{{asset('assets_front/images/pizza-center.png')}}" alt=""></a>
                      <a href="javascript:void(0)" onclick="preshowpriceright('{{$preTopping->id}}','{{$preTopping->toppings_price/2}}','{{$preTopping->toppings}}')" id="preshowpriceright_{{$preTopping->id}}" class="toppings_link pretopping_type"><img src="{{asset('assets_front/images/pizza-right.png')}}" alt=""></a>
                      <label class="preprice-pizzahalf{{$preTopping->id}}" style="display: none;" id="qtyleft">${{$preTopping->toppings_price/2}}</label>
                      <label class="preprice-pizzacircule{{$preTopping->id}}" style="display: none;">${{$preTopping->toppings_price}}</label>
                      <label class="preprice-pizzaright{{$preTopping->id}}" style="display: none;">${{$preTopping->toppings_price/2}}</label>
                      <br>
                      <input type="number" value="0" name="pretoppingsqty[]" id="pretoppingsqty{{$preTopping->id}}" class="toppingsqty" onchange="pretopsqtych('{{$preTopping->id}}','{{$preTopping->toppings_price}}')">
                    </p>
                  </dd>
                  <input type="hidden" id="pretoppings_left_name_{{$preTopping->id}}" name="pretoppings_left_name[]" />
                  <input type="hidden" id="pretoppings_left_id_{{$preTopping->id}}" name="pretoppings_left_id[]" />
                  <input type="hidden" id="pretoppings_center_name_{{$preTopping->id}}" name="pretoppings_center_name[]" />
                  <input type="hidden" id="pretoppings_center_id_{{$preTopping->id}}" name="pretoppings_center_id[]" />
                  <input type="hidden" id="pretoppings_right_name_{{$preTopping->id}}" name="pretoppings_right_name[]" />
                  <input type="hidden" id="pretoppings_right_id_{{$preTopping->id}}" name="pretoppings_right_id[]" />
                  @endforeach
                </form>
              </dl>
              <!-- close party premmiam topping -->

              <div class="content-element-2">
                <p class="mad-text-color-2 content-element">Cookings:</p>
                <div class="mad-toggled-fields hr-type">
                  @foreach($cookings as $cookings)
                  <input type="radio" name="cookings" id="radio-cookings{{$cookings->id}}">
                  <label for="radio-cookings{{$cookings->id}}" class="mad-label-radio" onclick="cookings('{{$cookings->cooking_price}}','{{$cookings->cooking}}')">{{$cookings->cooking}}
                    <p class="attrprice">${{$cookings->cooking_price}}</p>
                  </label>
                  @endforeach
                </div>
              </div>

              <div class="content-element-2">
                <p class="mad-text-color-2 content-element">Dippings:</p>
                <div class="mad-toggled-fields hr-type">
                  @foreach($dippings as $dippings)
                  <input type="radio" name="dippings" id="radio-dippings{{$dippings->id}}">
                  <label for="radio-dippings{{$dippings->id}}" class="mad-label-radio" onclick="dippings('{{$dippings->dipping_price}}','{{$dippings->dipping}}')">{{$dippings->dipping}}
                    <p class="attrprice">${{$dippings->dipping_price}}</p>
                  </label>
                  @endforeach
                </div>
              </div>

              <div class="content-element-2">
                <p class="mad-text-color-2 content-element">Wings:</p>
                <div class="mad-toggled-fields hr-type">
                  @foreach($wings as $wings)
                  <input type="radio" name="wings" id="radio-wings{{$wings->id}}">
                  <label for="radio-wings{{$wings->id}}" class="mad-label-radio" onclick="wings('{{$wings->ws_price}}','{{$wings->wings_sauce}}')">{{$wings->wings_sauce}}
                    <p class="attrprice">${{$wings->ws_price}}</p>
                  </label>
                  @endforeach
                </div>
              </div>

              @elseif($product->category_id == 5)
              <div class="content-element-2">
                <p class="mad-text-color-2 content-element">Sauces:</p>
                <div class="mad-toggled-fields hr-type">
                  @foreach($sauces as $sauces)
                  <input type="radio" name="sauces" id="radio-sauces{{$sauces->id}}">
                  <label for="radio-sauces{{$sauces->id}}" class="mad-label-radio" onclick="sauces('{{$sauces->sauce_price}}','{{$sauces->sauce}}')">{{$sauces->sauce}}
                    <p class="attrprice"> ${{$sauces->sauce_price}}</p>
                  </label>
                  @endforeach
                </div>
              </div>
              @endif
              <!-- order note -->
              <form id="note">
                <div class="content-element-2">
                  <p class="mad-text-color-2 content-element">Order Note:</p>
                  <textarea rows="5" placeholder="Message" class="noteorder" name="ordernote"></textarea>
                </div>
              </form>
              <!-- note close -->
              <div class="content-element-2">
                <p class="mad-text-color-2 content-element">Quantity:</p>
                <div class="btn-set big-btns">
                  <div class="quantity size-2">
                    <input type="text" value="1" readonly="" name="qty" id="qty">
                    <button type="button" class="qty-plus"><i class="licon-plus"></i></button>
                    <button type="button" class="qty-minus"><i class="licon-minus"></i></button>
                  </div>
                  <button id="add_to_cart_button" class="btn btn-big btn-style-3" onclick="add_to_cart('{{$product->id}}')"><i class="material-icons-outlined">shopping_cart</i><span>Add to
                      Cart</span></button>
                </div>
              </div>
            </div>

          </div>
          <div class="col-xl-2">
            <!-- <div class="image-preview-container">
              <div class="image-preview">
                <a href="{{asset('storage/media/'.$product->image)}}" data-zoom-image="{{asset('storage/media/'.$product->image)}}" data-fancybox="group">
                  <img id="zoom-image" src="{{asset('storage/media/'.$product->image)}}" alt="">
                </a>
              </div>
            </div> -->
          </div>
        </div>

      </div>
    </div>
  </div>
</div>
<form id="frmAddToCart">
  <input type="hidden" id="Product_name" name="product_name" value="{{$product->name}}" />
  <input type="hidden" id="Product_id" name="product_price" value="{{$product->product_price}}" />
  <input type="hidden" id="wings_name" name="wings_name" />
  <input type="hidden" id="wings_id" name="ws_price" />
  <input type="hidden" id="sauces_name" name="sauces_name" />
  <input type="hidden" id="sauces_id" name="sauce_price" />
  <!-- <input type="hidden" id="toppings_left_name" name="toppings_left_name[]" />
  <input type="hidden" id="toppings_left_id" name="toppings_left_id[]" />
  <input type="hidden" id="toppings_center_name" name="toppings_center_name[]" />
  <input type="hidden" id="toppings_center_id" name="toppings_center_id[]" />
  <input type="hidden" id="toppings_right_name" name="toppings_right_name[]" />
  <input type="hidden" id="toppings_right_id" name="toppings_right_id[]" /> -->
  <input type="hidden" id="crusts_name" name="crusts_name" />
  <input type="hidden" id="crusts_id" name="crust_price" />
  <input type="hidden" id="dippings_name" name="dippings_name" />
  <input type="hidden" id="dippings_id" name="dipping_price" />
  <input type="hidden" id="cookings_name" name="cookings_name" />
  <input type="hidden" id="cookings_id" name="cooking_price" />
  <input type="hidden" id="size_name" name="size_name" />
  <input type="hidden" id="size_price" name="size_price" />
  <input type="hidden" id="category_id" name="category_id" value="{{$product->category_id}}" />
  <input type="hidden" id="pqty" name="pqty" />
  @csrf
</form>

@endsection
@section('script')
<script src="{{ asset('assets_front/vendors/monkeysan.accordion.js') }}"></script>
<script>
  $(function() {
    $('#add_to_cart_button').prop('disabled', false);
  });

  function topsqtych(id, toppings_price) {
    qt = jQuery('#toppingsqty' + id).val();
    // total = toppings_price * qt;
    // jQuery('#toppings_left_id_' + id).val(total);
    // jQuery('label #qtyleft' + id).html(total);
    // alert(toppings_price * qt);
    id.val = qt;
    // jQuery('.topping_type.active').trigger('click');
    console.log(jQuery('.topping_type.active'));
    jQuery('.topping_type.active').click();
  }

  function showprice(id, toppings_price, toppings) {
    qt = jQuery('#toppingsqty' + id).val();
    if (qt == 0) {
      jQuery('#toppingsqty' + id).val(1);
      qt = 1;
    }
    total = toppings_price * qt;
    jQuery('#toppings_left_id_' + id).val(total);
    jQuery('.price-pizzahalf' + id).html('$' + total);
    jQuery('#toppings_left_name_' + id).val(toppings);
    // jQuery('#toppings_left_id').attr("name", 'toppings_left_id' + toppings);
    jQuery('.price-pizzaright' + id).hide();
    jQuery('.price-pizzacircule' + id).hide();
    jQuery('.price-pizzahalf' + id).show();
    jQuery('#showprice_' + id).css({
      'border': '1px solid black',
      'background-color': '#0080006b',
      'border-radius': '12px'
    });
    jQuery('.topping_type').removeClass('active');
    jQuery('#showprice_' + id).addClass('active');
    jQuery('#showpricenter_' + id).css({
      'border': 'none',
      'background-color': 'snow',
      'border-radius': 'unset'
    });
    jQuery('#showpriceright_' + id).css({
      'border': 'none',
      'background-color': 'snow',
      'border-radius': 'unset'
    });

  }

  function showpricenter(id, toppings_price, toppings) {
    qt = jQuery('#toppingsqty' + id).val();
    if (qt == 0) {
      jQuery('#toppingsqty' + id).val(1);
      qt = 1;
    }
    totalcenter = toppings_price * qt;
    jQuery('#toppingsqty' + id).val(qt);
    jQuery('#toppings_center_id_' + id).val(totalcenter);
    jQuery('.price-pizzacircule' + id).html('$' + totalcenter);
    jQuery('#toppings_center_name_' + id).val(toppings);
    // jQuery('#toppings_center_id').attr("name", 'toppings_center_id' + toppings);
    jQuery('.price-pizzaright' + id).hide();
    jQuery('.price-pizzacircule' + id).show();
    jQuery('.price-pizzahalf' + id).hide();
    jQuery('#showpricenter_' + id).css({
      'border': '1px solid black',
      'background-color': '#0080006b',
      'border-radius': '12px'
    });
    jQuery('.topping_type').removeClass('active');
    jQuery('#showpricenter_' + id).addClass('active');
    jQuery('#showpriceright_' + id).css({
      'border': 'none',
      'background-color': 'snow',
      'border-radius': 'unset'
    });
    jQuery('#showprice_' + id).css({
      'border': 'none',
      'background-color': 'snow',
      'border-radius': 'unset'
    });
  }

  function showpriceright(id, toppings_price, toppings) {
    qt = jQuery('#toppingsqty' + id).val();
    if (qt == 0) {
      jQuery('#toppingsqty' + id).val(1);
      qt = 1;
    }
    totalright = toppings_price * qt;
    jQuery('#toppingsqty' + id).val(qt);
    jQuery('#toppings_right_id_' + id).val(totalright);
    jQuery('.price-pizzaright' + id).html('$' + totalright);
    jQuery('#toppings_right_name_' + id).val(toppings);
    // jQuery('#toppings_right_id').attr("name", 'toppings_right_id' + toppings);
    jQuery('.price-pizzaright' + id).show();
    jQuery('.price-pizzacircule' + id).hide();
    jQuery('.price-pizzahalf' + id).hide();
    jQuery('#showpriceright_' + id).css({
      'border': '1px solid black',
      'background-color': '#0080006b',
      'border-radius': '12px'
    });
    jQuery('.topping_type').removeClass('active');
    jQuery('#showpriceright_' + id).addClass('active');
    jQuery('#showprice_' + id).css({
      'border': 'none',
      'background-color': 'snow',
      'border-radius': 'unset'
    });
    jQuery('#showpricenter_' + id).css({
      'border': 'none',
      'background-color': 'snow',
      'border-radius': 'unset'
    });
  }

  // premium toppings

  function pretopsqtych(id, toppings_price) {
    qt = jQuery('#pretoppingsqty' + id).val();
    // total = toppings_price * qt;
    // jQuery('#toppings_left_id_' + id).val(total);
    // jQuery('label #qtyleft' + id).html(total);
    // alert(toppings_price * qt);
    id.val = qt;
    // jQuery('.pretopping_type.active').trigger('click');
    console.log(jQuery('.pretopping_type.active'));
    jQuery('.pretopping_type.active').click();
  }

  function preshowprice(id, toppings_price, toppings) {
    qt = jQuery('#pretoppingsqty' + id).val();
    if (qt == 0) {
      jQuery('#pretoppingsqty' + id).val(1);
      qt = 1;
    }
    total = toppings_price * qt;
    jQuery('#pretoppings_left_id_' + id).val(total);
    jQuery('.preprice-pizzahalf' + id).html('$' + total);
    jQuery('#pretoppings_left_name_' + id).val(toppings);
    // jQuery('#toppings_left_id').attr("name", 'toppings_left_id' + toppings);
    jQuery('.preprice-pizzaright' + id).hide();
    jQuery('.preprice-pizzacircule' + id).hide();
    jQuery('.preprice-pizzahalf' + id).show();
    jQuery('#preshowprice_' + id).css({
      'border': '1px solid black',
      'background-color': '#0080006b',
      'border-radius': '12px'
    });
    jQuery('.pretopping_type').removeClass('active');
    jQuery('#preshowprice_' + id).addClass('active');
    jQuery('#preshowpricenter_' + id).css({
      'border': 'none',
      'background-color': 'snow',
      'border-radius': 'unset'
    });
    jQuery('#preshowpriceright_' + id).css({
      'border': 'none',
      'background-color': 'snow',
      'border-radius': 'unset'
    });

  }

  function preshowpricenter(id, toppings_price, toppings) {
    qt = jQuery('#pretoppingsqty' + id).val();
    if (qt == 0) {
      jQuery('#pretoppingsqty' + id).val(1);
      qt = 1;
    }
    totalcenter = toppings_price * qt;
    jQuery('#pretoppingsqty' + id).val(qt);
    jQuery('#pretoppings_center_id_' + id).val(totalcenter);
    jQuery('.preprice-pizzacircule' + id).html('$' + totalcenter);
    jQuery('#pretoppings_center_name_' + id).val(toppings);
    // jQuery('#toppings_center_id').attr("name", 'toppings_center_id' + toppings);
    jQuery('.preprice-pizzaright' + id).hide();
    jQuery('.preprice-pizzacircule' + id).show();
    jQuery('.preprice-pizzahalf' + id).hide();
    jQuery('#preshowpricenter_' + id).css({
      'border': '1px solid black',
      'background-color': '#0080006b',
      'border-radius': '12px'
    });
    jQuery('.pretopping_type').removeClass('active');
    jQuery('#preshowpricenter_' + id).addClass('active');
    jQuery('#preshowpriceright_' + id).css({
      'border': 'none',
      'background-color': 'snow',
      'border-radius': 'unset'
    });
    jQuery('#preshowprice_' + id).css({
      'border': 'none',
      'background-color': 'snow',
      'border-radius': 'unset'
    });
  }

  function preshowpriceright(id, toppings_price, toppings) {
    qt = jQuery('#pretoppingsqty' + id).val();
    if (qt == 0) {
      jQuery('#pretoppingsqty' + id).val(1);
      qt = 1;
    }
    totalright = toppings_price * qt;
    jQuery('#pretoppingsqty' + id).val(qt);
    jQuery('#pretoppings_right_id_' + id).val(totalright);
    jQuery('.preprice-pizzaright' + id).html('$' + totalright);
    jQuery('#pretoppings_right_name_' + id).val(toppings);
    // jQuery('#toppings_right_id').attr("name", 'toppings_right_id' + toppings);
    jQuery('.preprice-pizzaright' + id).show();
    jQuery('.preprice-pizzacircule' + id).hide();
    jQuery('.preprice-pizzahalf' + id).hide();
    jQuery('#preshowpriceright_' + id).css({
      'border': '1px solid black',
      'background-color': '#0080006b',
      'border-radius': '12px'
    });
    jQuery('.pretopping_type').removeClass('active');
    jQuery('#preshowpriceright_' + id).addClass('active');
    jQuery('#preshowprice_' + id).css({
      'border': 'none',
      'background-color': 'snow',
      'border-radius': 'unset'
    });
    jQuery('#preshowpricenter_' + id).css({
      'border': 'none',
      'background-color': 'snow',
      'border-radius': 'unset'
    });
  }


  // close premium toppings
  function wings(ws_price, wings_sauce) {
    jQuery('#wings_id').val(ws_price);
    jQuery('#wings_name').val(wings_sauce);
    // jQuery('#wings_id').attr("name", 'wings_id' + wings_sauce);
  }

  function sauces(sauce_price, sauce) {
    jQuery('#sauces_id').val(sauce_price);
    jQuery('#sauces_name').val(sauce);
    // jQuery('#sauces_id').attr("name", 'sauces_id' + sauce);
  }

  function crusts(crust_price, crust) {
    jQuery('#crusts_id').val(crust_price);
    jQuery('#crusts_name').val(crust);
    // jQuery('#crusts_id').attr("name", 'crusts_id' + crust);
  }

  function dippings(dipping_price, dipping) {
    jQuery('#dippings_id').val(dipping_price);
    jQuery('#dippings_name').val(dipping);
    // jQuery('#dippings_id').attr("name", 'dippings_id' + dipping);
  }

  function cookings(cooking_price, cooking) {
    jQuery('#cookings_id').val(cooking_price);
    jQuery('#cookings_name').val(cooking);
    // jQuery('#cookings_id').attr("name", 'cookings_id' + cooking);
  }

  function size(price, size) {
    jQuery('#size_price').val(price);
    jQuery('#size_name').val(size);
    // jQuery('$small.is(':checked')').attr("name", 'crusts_id' + crust);
    jQuery('#p_price').hide();
    jQuery('#Product_id').val(0);
    // sizesmal = jQuery(size.target).text(size);
    sizecheck = jQuery('#size_name').val();
    if (sizecheck == 'Small(4slice)') {
      jQuery('#mediamtoping').hide();
      jQuery('#largetoping').hide();
      jQuery('#partytoping').hide();
      jQuery('#smalltoping').show();
      jQuery('#toppings_data_mediam').trigger("reset");
      jQuery('#toppings_data_large').trigger("reset");
      jQuery('#toppings_data_party').trigger("reset");

      // premiam

      jQuery('#mediampretoping').hide();
      jQuery('#largepretoping').hide();
      jQuery('#partypretoping').hide();
      jQuery('#smallpretoping').show();
      jQuery('#pretoppings_data_mediam').trigger("reset");
      jQuery('#pretoppings_data_large').trigger("reset");
      jQuery('#pretoppings_data_party').trigger("reset");

    } else if (sizecheck == 'Medium(8slice)') {
      jQuery('#mediamtoping').show();
      jQuery('#largetoping').hide();
      jQuery('#partytoping').hide();
      jQuery('#smalltoping').hide();
      jQuery('#toppings_data').trigger("reset");
      jQuery('#toppings_data_large').trigger("reset");
      jQuery('#toppings_data_party').trigger("reset");

      // premiam

      jQuery('#mediampretoping').show();
      jQuery('#largepretoping').hide();
      jQuery('#partypretoping').hide();
      jQuery('#smallpretoping').hide();
      jQuery('#pretoppings_data_small').trigger("reset");
      jQuery('#pretoppings_data_large').trigger("reset");
      jQuery('#pretoppings_data_party').trigger("reset");

    } else if (sizecheck == 'Large(12slice)') {
      jQuery('#mediamtoping').hide();
      jQuery('#largetoping').show();
      jQuery('#partytoping').hide();
      jQuery('#smalltoping').hide();
      jQuery('#toppings_data').trigger("reset");
      jQuery('#toppings_data_mediam').trigger("reset");
      jQuery('#toppings_data_party').trigger("reset");

      // premiam

      jQuery('#mediampretoping').hide();
      jQuery('#largepretoping').show();
      jQuery('#partypretoping').hide();
      jQuery('#smallpretoping').hide();
      jQuery('#pretoppings_data_small').trigger("reset");
      jQuery('#pretoppings_data_mediam').trigger("reset");
      jQuery('#pretoppings_data_party').trigger("reset");

    } else if (sizecheck == 'Party(24slice)') {
      jQuery('#mediamtoping').hide();
      jQuery('#largetoping').hide();
      jQuery('#partytoping').show();
      jQuery('#smalltoping').hide();
      jQuery('#toppings_data').trigger("reset");
      jQuery('#toppings_data_mediam').trigger("reset");
      jQuery('#toppings_data_large').trigger("reset");

      // premiam

      jQuery('#mediampretoping').hide();
      jQuery('#largepretoping').hide();
      jQuery('#partypretoping').show();
      jQuery('#smallpretoping').hide();
      jQuery('#pretoppings_data_small').trigger("reset");
      jQuery('#pretoppings_data_mediam').trigger("reset");
      jQuery('#pretoppings_data_large').trigger("reset");

    }
  }

  function add_to_cart(id) {
    $('#add_to_cart_button').prop('disabled', true);
    var toppings_left_id = jQuery('#toppings_left_id').val();
    var toppings_center_id = jQuery('#toppings_center_id').val();
    var toppings_right_id = jQuery('#toppings_right_id').val();
    var wings_id = jQuery('#wings_id').val();
    var sauces_id = jQuery('#sauces_id').val();
    var crusts_id = jQuery('#crusts_id').val();
    var dippings_id = jQuery('#dippings_id').val();
    var cookings_id = jQuery('#cookings_id').val();

    jQuery('#product_id').val(id);
    jQuery('#pqty').val(jQuery('#qty').val());
    jQuery.ajax({
      url: '/add_to_cart',
      data: jQuery('#frmAddToCart').serialize() + '&' + jQuery('#toppings_data').serialize() + '&' + jQuery('#toppings_data_mediam').serialize() + '&' + jQuery('#toppings_data_large').serialize() + '&' + jQuery('#toppings_data_party').serialize() + '&' + jQuery('#pretoppings_data_small').serialize() + '&' + jQuery('#pretoppings_data_mediam').serialize() + '&' + jQuery('#pretoppings_data_large').serialize() + '&' + jQuery('#pretoppings_data_party').serialize() + '&' + jQuery('#note').serialize(),
      type: 'post',
      success: function(result) {
        // jQuery('#frmAddToCart')[0].reset();
        // jQuery('#toppings_data')[0].reset();
        jQuery('#thank_you_msg').html(result.msg);
        window.location.href = result.redirect;
      }
    })
  }
</script>
@endsection