<?php

namespace App\Http\Controllers;

use App\Models\sauces;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class SaucesController extends Controller
{
    public function index(Request $request, $id = '')
    {
        if ($id > 0) {
            $arr = sauces::where(['id' => $id])->get();

            $result['sauce'] = $arr['0']->sauce;
            $result['sauce_price'] = $arr['0']->sauce_price;
            $result['status'] = $arr['0']->status;
            $result['id']=$arr['0']->id;
        } else {
            $result['sauce'] = '';
            $result['sauce_price'] = '';
            $result['status'] = '';
            $result['id']=0;
        }
        $sauces = sauces::all();
        return view('admin/sauce', compact('sauces'),$result);
    }

    public function create(Request $request)
    {
        $validatedData = $request->validate([
            "sauce" => 'required|unique:sauces,sauce,'.$request->input('id'),

        ]);
        if($request->input('id')>0){
            $sauces=sauces::find($request->input('id'));
            $msg="Size updated";
        }else{
            $sauces = new sauces;
            $msg="Size inserted";
        }
        $sauces->sauce = $request->input('sauce');
        $sauces->sauce_price = $request->input('sauce_price');
        $sauces->status=1;
        $sauces->save();
        Session::flash('message', $msg);
        return redirect('admin/sauce');
    }


    public function store(Request $request)
    {
    }

    public function show(sauces $sauces)
    {
    }

    public function edit(sauces $sauces)
    {
    }

    public function status(Request $request,$status,$id){
        $model=sauces::find($id);
        $model->status=$status;
        $model->save();
        Session::flash('message','Sauce status updated');
        return redirect('admin/sauce');
    }

    public function delete(Request $request, $id)
    {
        $model = sauces::find($id);
        $model->delete();
        Session::flash('message', 'Sauce deleted');
        return redirect('admin/sauce');
    }
}
