<?php

namespace App\Http\Controllers;

use App\Models\checkout;
use App\Models\add_to_cart;
use App\Models\insert_topping;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;

class CheckoutController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->session()->has('FRONT_USER_LOGIN')) {
            $uid = $request->session()->get('FRONT_USER_ID');
            $user_type = "Reg";
        } else {
            $uid = getUserTempId();
            $user_type = "Not-Reg";
        }
        $results = add_to_cart::query()->with('insert_topping')
            ->where(['user_id' => $uid])
            ->where(['user_type' => $user_type])
            ->where(['status' => null])
            ->get();

        // $results = add_to_cart::with('insert_topping')->get();
        // $results = add_to_cart::all();


        $i = 0;
        foreach ($results as $result) {
            if ($result->category_id == 1) {


                $total_price = 0;
                $total_price = ($result->product_price + $result->ws_price + $result->sauce_price + $result->crust_price + $result->dipping_price + $result->cooking_price + $result->size_price);
                foreach ($result->insert_topping as $insert_topping) {

                    if ($insert_topping->sum('status') >= 3) {
                        $total_price += $insert_topping->toppings_left_id = 0 + $insert_topping->toppings_center_id = 0 + $insert_topping->toppings_right_id = 0 + $insert_topping->pretoppings_left_id = 0 + $insert_topping->pretoppings_center_id = 0 + $insert_topping->pretoppings_right_id = 0;
                    } else {
                        $total_price += $insert_topping->toppings_left_id + $insert_topping->toppings_center_id + $insert_topping->toppings_right_id + $insert_topping->pretoppings_left_id  + $insert_topping->pretoppings_center_id  + $insert_topping->pretoppings_right_id;
                    }
                }
            } else {
                $total_price = 0;
                $total_price = ($result->product_price + $result->ws_price + $result->sauce_price + $result->crust_price + $result->dipping_price + $result->cooking_price + $result->size_price);
                foreach ($result->insert_topping as $insert_topping) {
                    $total_price += $insert_topping->toppings_left_id + $insert_topping->toppings_center_id + $insert_topping->toppings_right_id + $insert_topping->pretoppings_left_id  + $insert_topping->pretoppings_center_id  + $insert_topping->pretoppings_right_id;
                }
            }

            $results[$i]->total_price = $total_price * $result->pqty;
            $i++;
        }

        return view('front/checkout', compact('results'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function ordercomplete(Request $request)
    {
        if ($request->session()->has('FRONT_USER_LOGIN')) {
            $uid = $request->session()->get('FRONT_USER_ID');
            $user_type = "Reg";
        } else {
            $uid = getUserTempId();
            $user_type = "Not-Reg";
        }

        // $request->all();
        $checkouts = new checkout;
        $checkouts->email = $request->input('email');
        $checkouts->phone = $request->input('phone');
        $checkouts->fname = $request->input('fname');
        $checkouts->lname = $request->input('lname');
        $checkouts->street = $request->input('street');
        $checkouts->appertment = $request->input('appertment');
        $checkouts->zipcode = $request->input('zipcode');
        $checkouts->note = $request->input('note');
        $checkouts->user_id = $request->input('user_id');
        $checkouts->delivered_type = $request->input('delivered_type');
        $checkouts->payment_types = $request->input('payment_types');
        $checkouts->total_price = $request->input('total_price');
        $checkouts->save();

        $checkouts = DB::table('checkouts')->latest('id')->first();

        $saverecord = [
            'checkouts_id' => $checkouts->id,
            'status' => "checkout",
        ];
        DB::table('add_to_carts')->where('user_id', $uid)->whereDate('created_at', Carbon::today())->update($saverecord);

        // foreach ($request->wings_name as $key => $insert) {
        //     $product_att = [
        //         'product_name' => $request->product_name[$key],
        //         'product_price' => $request->product_price[$key],
        //         'pqty' => $request->pqty[$key],
        //         'wings_name' => $request->wings_name[$key],
        //         'ws_price' => $request->ws_price[$key],
        //         'sauces_name' => $request->sauces_name[$key],
        //         'sauce_price' => $request->sauce_price[$key],
        //         'crusts_name' => $request->crusts_name[$key],
        //         'crust_price' => $request->crust_price[$key],
        //         'dippings_name' => $request->dippings_name[$key],
        //         'dipping_price' => $request->dipping_price[$key],
        //         'cookings_name' => $request->cookings_name[$key],
        //         'cooking_price' => $request->cooking_price[$key],
        //         'total_price' => $request->total_price[$key],
        //         'checkout_id' => $checkouts->id,
        //     ];

        //     $lastInsertID = DB::table('product_ckeckout_attrs')->insert($product_att);
        // }

        // $checkouts = DB::table('checkouts')->latest('id')->first();
        // $product_ckeckout_attrs = DB::table('add_to_carts')->latest('id')->first();
        // foreach ($request->toppings_left_name as $key => $insert) {

        //     if (isset($request->toppingsqty[$key]) && $request->toppingsqty[$key] != null && $request->toppingsqty[$key] != 0) {
        //         $saverecord = [
        //             'toppings_left_name' => $request->toppings_left_name[$key],
        //             'toppings_left_id' => $request->toppings_left_id[$key],
        //             'toppings_center_name' => $request->toppings_center_name[$key],
        //             'toppings_center_id' => $request->toppings_center_id[$key],
        //             'toppings_right_name' => $request->toppings_right_name[$key],
        //             'toppings_right_id' => $request->toppings_right_id[$key],
        //             'toppingsqty' => $request->toppingsqty[$key],
        //             'checkout_id' => $checkouts->id,
        //             'product_ckeckout_attrs_id' => $product_ckeckout_attrs->id,
        //         ];

        //         DB::table('order_toppings_completes')->insert($saverecord);
        //     }
        // }

        // if ($request->user_id == $uid) {
        //     $id = [];
        //     $id = $request->product_id;

        //     $model = add_to_cart::wherein('id', $id)->delete();

        //     $model = insert_topping::where('add_to_cart_id', $id)->delete();
        //     Session::flash('message', 'Cart deleted');
        // }

        // return redirect('thankyou');
        Session::put('checkouts_id', $checkouts->id);
        return [
            'msg' => 'Successfully added in Order.',
            'redirect' => '/thankyou',
        ];
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\checkout  $checkout
     * @return \Illuminate\Http\Response
     */
    public function delete(checkout $checkout, $id)
    {
        $model = add_to_cart::find($id);
        $model->insert_topping()->delete();
        $model->delete();
        Session::flash('message', 'Cart deleted');
        return redirect('checkout');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\checkout  $checkout
     * @return \Illuminate\Http\Response
     */
    public function order_data_for_admin(checkout $checkout)
    {
        //$order_for_admin = checkout::query()->with('product_attr', 'toppings_complete')->get();
        $order_for_admin = checkout::all()->sortByDesc("id");
        // dd($order_for_admin);

        return view('admin/order', compact('order_for_admin'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\checkout  $checkout
     * @return \Illuminate\Http\Response
     */
    public function order_detail(Request $request, $id)
    {
        // if ($request->session()->has('FRONT_USER_LOGIN')) {
        //     $uid = $request->session()->get('FRONT_USER_ID');
        //     $user_type = "Reg";
        // } else {
        //     $uid = getUserTempId();
        //     $user_type = "Not-Reg";
        // }

        //$result['orders_details'] =  $result['order_Completes'] = checkout::query()->with('add_to_carts', 'toppings_complete')->where('user_id', $uid)->get();

        $result['checkouts_customer'] =
            DB::table('checkouts')
            ->where(['checkouts.id' => $id])
            ->get();

        foreach ($result['checkouts_customer'] as $checkout_user_id) {
            $get_user_id = $checkout_user_id->user_id;
        }

        $result['orders_details'] =
            DB::table('add_to_carts')
            // ->leftJoin('add_to_carts','add_to_carts.checkouts_id', '=', 'checkouts.id')
            // ->leftJoin('insert_toppings', 'add_to_carts.id', '=', 'insert_toppings.add_to_cart_id')
            ->where(['add_to_carts.checkouts_id' => $id])
            ->where(['add_to_carts.user_id' => $get_user_id])
            ->get();

        $result['orders_toppings'] =
            DB::table('insert_toppings')
            ->leftJoin('add_to_carts', 'add_to_carts.id', '=', 'insert_toppings.add_to_cart_id')
            //->where(['insert_toppings.add_to_cart_id' => 'add_to_carts.id'])
            ->where(['add_to_carts.checkouts_id' => $id])
            ->where(['add_to_carts.user_id' => $get_user_id])
            ->get();
        // dd($result['orders_toppings']);
        // $result['payment_status'] = ['Pending', 'Success', 'Fail'];
        return view('admin.orderdetail', $result);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\checkout  $checkout
     * @return \Illuminate\Http\Response
     */
    public function destroy(checkout $checkout)
    {
        //
    }
}
